/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize

/////////////////////////////////////////////////////////////////////////////////

// not really a quasi crystal

void main(void) {
	vec2 uv = gl_FragCoord.xy / iResolution.xy;
		
	float frequency = 0.02;  // effective zoom level higher to zoom out
	float gray = 0.0;
	
	// const fix for linux: http://www.khronos.org/webgl/public-mailing-list/archives/1012/msg00063.html
	const int waves = 7;
	
	float degrees = 180.0 / float(waves);	
	
	float normalization_factor = 1.0 / (1.0 + float(waves));
	
	for (int index = 0; index < waves; index++) {		
		gray += normalization_factor + normalization_factor * 
				 tan(
					cos(float(index) * radians(degrees)) * (gl_FragCoord.x - 0.5 * iResolution.x) * frequency
				  + sin(float(index) * radians(degrees)) * (gl_FragCoord.y - 0.5 * iResolution.y) * frequency
				  + iGlobalTime);		
	}
	
	gl_FragColor = vec4(vec3(gray), 1.0);
}
